package ru.yandex.partner.core.entity.page.actions;

import org.jooq.DSLContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.SimpleActionErrorHandler;
import ru.yandex.partner.core.action.log.AbstractActionsLogger;
import ru.yandex.partner.core.action.log.SimpleDbActionLogger;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.MobileAppSettingsCopyMapper;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.page.repository.PageModifyRepository;
import ru.yandex.partner.core.entity.page.service.type.update.PageUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.page.service.validation.type.PageValidationTypeSupportFacade;
import ru.yandex.partner.dbschema.partner.tables.MobileAppSettingsActionLog;
import ru.yandex.partner.dbschema.partner.tables.records.MobileAppSettingsActionLogRecord;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@Configuration
public class MobileAppSettingsActionConfig {
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    @Bean
    @SuppressWarnings("checkstyle:parameternumber")
    MobileAppSettingsActionContext mobileAppActionContext(
            DSLContext dslContext,
            ModelQueryService<BasePage> modelQueryService,
            MobileAppSettingsCopyMapper mobileAppCopyMapper,
            PageUpdateOperationTypeSupportFacade updateOperationTypeSupport,
            PageModifyRepository pageModifyRepository,
            PageValidationTypeSupportFacade pageValidationTypeSupportFacade,
            AbstractActionsLogger<MobileAppSettingsActionLogRecord> actionLogger,
            ActionErrorHandler<MobileAppSettings> errorHandler
    ) {
        return new MobileAppSettingsActionContext(
                dslContext,
                actionLogger,
                errorHandler,
                modelQueryService,
                mobileAppCopyMapper::copy,
                updateOperationTypeSupport,
                pageModifyRepository,
                pageValidationTypeSupportFacade
        );
    }

    @TransactionWithFallbackScope
    @Bean
    ActionErrorHandler<MobileAppSettings> mobileAppErrorHandler() {
        return new SimpleActionErrorHandler<>();
    }

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    AbstractActionsLogger<MobileAppSettingsActionLogRecord>
    mobileAppActionsLogger(DSLContext dslContext, ActionUserIdContext actionUserIdContext) {
        return new SimpleDbActionLogger<>(
                dslContext,
                MobileAppSettingsActionLog.MOBILE_APP_SETTINGS_ACTION_LOG,
                this::buildActionLogRecord,
                actionUserIdContext
        );
    }

    public MobileAppSettingsActionLogRecord buildActionLogRecord(
            Long userId, Long modelId, long oldMultistate, String actionName, long newMultistate, String opts) {
        var record = new MobileAppSettingsActionLogRecord();
        record.setDt(PartnerLocalDateTime.now());
        record.setUserId(userId);
        record.setElemId(modelId);
        record.setOldMultistate(oldMultistate);
        record.setAction(actionName);
        record.setNewMultistate(newMultistate);
        record.setOpts(opts);
        return record;
    }
}
