package ru.yandex.partner.core.entity.page.actions;

import java.util.function.Function;

import org.jooq.DSLContext;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.TypeSupportActionContext;
import ru.yandex.partner.core.action.log.ActionsLogger;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.page.repository.PageModifyRepository;
import ru.yandex.partner.core.entity.page.service.type.update.PageUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.page.service.validation.type.PageValidationTypeSupportFacade;

public class MobileAppSettingsActionContext extends TypeSupportActionContext<BasePage, MobileAppSettings,
        PageOperationContainer> {
    @SuppressWarnings("ParameterNumber")
    public MobileAppSettingsActionContext(
            DSLContext dslContext,
            ActionsLogger actionsLogger,
            ActionErrorHandler<MobileAppSettings> actionErrorHandler,
            ModelQueryService<? super MobileAppSettings> queryService,
            Function<MobileAppSettings, MobileAppSettings> copyFunction,
            PageUpdateOperationTypeSupportFacade updateOperationTypeSupport,
            PageModifyRepository pageModifyRepository,
            PageValidationTypeSupportFacade validationTypeSupportFacade
    ) {
        super(
                MobileAppSettings.class,
                actionsLogger,
                actionErrorHandler,
                queryService,
                copyFunction,
                dslContext,
                updateOperationTypeSupport,
                pageModifyRepository,
                validationTypeSupportFacade,
                PageOperationContainer::create
        );
    }
}
