package ru.yandex.partner.core.entity.page.actions;

import ru.yandex.partner.libs.multistate.action.ActionNameHolder;

public enum PageActionsEnum implements ActionNameHolder {
    ADD,
    BK_IMPORT_WORKING,
    BK_IMPORT_TESTING,
    BK_IMPORT_DELETED,
    REGISTER_IN_BALANCE,
    START,
    START_TESTING,
    STOP_TESTING,
    STOP,
    DELETE,
    RESTORE,
    EDIT,
    DEL_MIRROR,
    SET_READ_ONLY,
    RESET_READ_ONLY,
    SET_BLOCKED,
    RESET_BLOCKED,
    SET_CHECK_STATISTICS,
    RESET_CHECK_STATISTICS,
    RESTORE_BLOCK,
    START_BLOCK,
    SET_NEED_UPDATE,
    APPROVE,
    SET_NEED_APPROVE,
    REJECT,
    CAN_UPDATE_IN_BK,
    SET_PROTECTED,
    RESET_PROTECTED,
    START_UPDATE,
    STOP_UPDATE;

    private final String actionName;

    PageActionsEnum(String actionName) {
        this.actionName = actionName;
    }

    PageActionsEnum() {
        this.actionName = name().toLowerCase();
    }

    @Override
    public String getActionName() {
        return actionName;
    }
}
