package ru.yandex.partner.core.entity.page.actions.factory;

import java.util.Collection;

import ru.yandex.partner.core.action.AbstractTransitionActionWithModelProperty;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerWithModelProperty;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.page.model.PageWithMultistate;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.libs.multistate.graph.PageMultistateGraph;

public abstract class AbstractPageAction<T extends PageWithMultistate> extends
        AbstractTransitionActionWithModelProperty<T, PageStateFlag, Void> {

    private final PageMultistateGraph<? super T> multistateGraph;

    @SuppressWarnings("ParameterNumber")
    public AbstractPageAction(
            ActionConfiguration<T, ?> parentFactory,
            String name,
            Collection<Long> containerIds,
            PageMultistateGraph<? super T> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<T> actionErrorHandler) {
        super(
                parentFactory,
                name,
                containerIds,
                multistateGraph,
                actionPerformer,
                actionErrorHandler
        );

        this.multistateGraph = multistateGraph;
    }

    @Override
    public Multistate<PageStateFlag> getMultistate(T model) {
        return model.getMultistate();
    }

    @Override
    public void setMultistate(ActionModelContainerWithModelProperty<T> container,
                              Multistate<PageStateFlag> multistate) {
        container.changeProperty(
                PageWithMultistate.MULTISTATE,
                multistateGraph.convertMultistate(multistate.getEnabledFlags())
        );
    }

}
