package ru.yandex.partner.core.entity.page.actions.factory;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.page.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.entity.page.actions.PageActionsEnum;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.libs.multistate.graph.PageMultistateGraph;

@Component
public class ContextPageSetNeedUpdateActionFactory
        extends CustomPayloadActionFactory<ContextPage, PageSetNeedUpdate<ContextPage>>
        implements ActionSetNeedUpdateFactory<ContextPage, PageStateFlag> {
    private final PageMultistateGraph<ContextPage> multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<ContextPage> actionErrorHandler;

    public ContextPageSetNeedUpdateActionFactory(
            PageMultistateGraph<ContextPage> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<ContextPage> actionErrorHandler) {
        super(new SmartActionConfigurationFactory<>(PageActionsEnum.SET_NEED_UPDATE, multistateGraph,
                ContextPage.UPDATE_TIME, ContextPage.BLOCKS_COUNT, ContextPage.BLOCKS_LIMIT));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
    }

    @Override
    public PageSetNeedUpdate<ContextPage> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return PageActionsEnum.SET_NEED_UPDATE.getActionName();
    }

    @Override
    public PageSetNeedUpdate<ContextPage> createAction(Collection<Long> ids) {
        return new PageSetNeedUpdate<>(
                ContextPage.class,
                getActionConfiguration(),
                getName(),
                ids,
                multistateGraph,
                actionPerformer,
                actionErrorHandler
        );
    }

    @Override
    public Class<ContextPage> getModelClass() {
        return ContextPage.class;
    }
}
