package ru.yandex.partner.core.entity.page.actions.factory;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.page.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.entity.page.actions.PageActionsEnum;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.libs.multistate.graph.PageMultistateGraph;

@Component
public class InternalMobileAppSetNeedUpdateActionFactory
        extends CustomPayloadActionFactory<InternalMobileApp, PageSetNeedUpdate<InternalMobileApp>>
        implements ActionSetNeedUpdateFactory<InternalMobileApp, PageStateFlag> {
    private final PageMultistateGraph<InternalMobileApp> multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<InternalMobileApp> actionErrorHandler;

    public InternalMobileAppSetNeedUpdateActionFactory(
            PageMultistateGraph<InternalMobileApp> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<InternalMobileApp> actionErrorHandler) {
        super(new SmartActionConfigurationFactory<>(PageActionsEnum.SET_NEED_UPDATE, multistateGraph,
                InternalMobileApp.UPDATE_TIME, InternalMobileApp.BLOCKS_COUNT, InternalMobileApp.BLOCKS_LIMIT));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
    }

    @Override
    public PageSetNeedUpdate<InternalMobileApp> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return PageActionsEnum.SET_NEED_UPDATE.getActionName();
    }

    @Override
    public PageSetNeedUpdate<InternalMobileApp> createAction(Collection<Long> ids) {
        return new PageSetNeedUpdate<>(
                InternalMobileApp.class,
                getActionConfiguration(),
                getName(),
                ids,
                multistateGraph,
                actionPerformer,
                actionErrorHandler
        );
    }

    @Override
    public Class<InternalMobileApp> getModelClass() {
        return InternalMobileApp.class;
    }
}
