package ru.yandex.partner.core.entity.page.actions.factory;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.page.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.entity.page.actions.PageActionsEnum;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.libs.multistate.graph.PageMultistateGraph;

@Component
public class MobileAppSetNeedUpdateActionFactory
        extends CustomPayloadActionFactory<MobileAppSettings, PageSetNeedUpdate<MobileAppSettings>>
        implements ActionSetNeedUpdateFactory<MobileAppSettings, PageStateFlag> {
    private final PageMultistateGraph<MobileAppSettings> multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<MobileAppSettings> actionErrorHandler;

    public MobileAppSetNeedUpdateActionFactory(
            PageMultistateGraph<MobileAppSettings> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<MobileAppSettings> actionErrorHandler) {
        super(new SmartActionConfigurationFactory<>(PageActionsEnum.SET_NEED_UPDATE, multistateGraph,
                MobileAppSettings.UPDATE_TIME, MobileAppSettings.BLOCKS_COUNT, MobileAppSettings.BLOCKS_LIMIT));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
    }

    @Override
    public PageSetNeedUpdate<MobileAppSettings> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return PageActionsEnum.SET_NEED_UPDATE.getActionName();
    }

    @Override
    public PageSetNeedUpdate<MobileAppSettings> createAction(Collection<Long> ids) {
        return new PageSetNeedUpdate<>(
                MobileAppSettings.class,
                getActionConfiguration(),
                getName(),
                ids,
                multistateGraph,
                actionPerformer,
                actionErrorHandler
        );
    }

    @Override
    public Class<MobileAppSettings> getModelClass() {
        return MobileAppSettings.class;
    }
}
