package ru.yandex.partner.core.entity.page.actions.factory;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.page.model.PageWithCommonFields;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;
import ru.yandex.partner.libs.multistate.graph.PageMultistateGraph;

public class PageSetNeedUpdate<T extends PageWithCommonFields> extends AbstractPageAction<T> {
    private final Class<T> pageClass;

    @SuppressWarnings("ParameterNumber")
    public PageSetNeedUpdate(
            Class<T> pageClass,
            ActionConfiguration<T, ?> parentFactory,
            String name,
            Collection<Long> containerIds,
            PageMultistateGraph<? super T> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<T> actionErrorHandler) {
        super(parentFactory, name, containerIds, multistateGraph, actionPerformer, actionErrorHandler
        );
        this.pageClass = pageClass;
    }

    @Override
    public String getSerializedOpts(Long id) {
        return "{}";
    }

    @Override
    public Class<T> getEntityClass() {
        return pageClass;
    }

    @Override
    public void onAction(ActionContext<T, ActionModelContainerImpl<T>> tActionModelContainerActionContext,
                         List<ActionModelContainerImpl<T>> containers) {
        LocalDateTime updateTime = PartnerLocalDateTime.now();
        for (ActionModelContainerImpl<T> container : containers) {
            container.changeProperty(PageWithCommonFields.UPDATE_TIME, updateTime);
        }
    }

    @Override
    public boolean writeActionLog() {
        return false;
    }
}
