package ru.yandex.partner.core.entity.page.actions.factory.internal;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.page.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.entity.page.actions.PageActionsEnum;
import ru.yandex.partner.core.entity.page.actions.factory.PageSetNeedUpdate;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.libs.multistate.graph.PageMultistateGraph;

@Component
public class InternalContextPageSetNeedUpdateActionFactory
        extends CustomPayloadActionFactory<InternalContextPage, PageSetNeedUpdate<InternalContextPage>>
        implements ActionSetNeedUpdateFactory<InternalContextPage, PageStateFlag> {
    private final PageMultistateGraph<InternalContextPage> multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<InternalContextPage> actionErrorHandler;

    @Autowired
    public InternalContextPageSetNeedUpdateActionFactory(
            PageMultistateGraph<InternalContextPage> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<InternalContextPage> actionErrorHandler) {
        super(new SmartActionConfigurationFactory<>(PageActionsEnum.SET_NEED_UPDATE, multistateGraph,
                InternalContextPage.UPDATE_TIME, InternalContextPage.BLOCKS_COUNT, InternalContextPage.BLOCKS_LIMIT));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
    }

    @Override
    public PageSetNeedUpdate<InternalContextPage> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return PageActionsEnum.SET_NEED_UPDATE.getActionName();
    }

    @Override
    public PageSetNeedUpdate<InternalContextPage> createAction(Collection<Long> ids) {
        return new PageSetNeedUpdate<>(
                InternalContextPage.class,
                getActionConfiguration(),
                getName(),
                ids,
                multistateGraph,
                actionPerformer,
                actionErrorHandler
        );
    }

    @Override
    public Class<InternalContextPage> getModelClass() {
        return InternalContextPage.class;
    }
}

