package ru.yandex.partner.core.entity.page.filter;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.filter.container.DefaultModelFilterContainer;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.dbmeta.SubFilter;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;
import static ru.yandex.partner.dbschema.partner.Tables.MANAGERS;
import static ru.yandex.partner.dbschema.partner.Tables.USERS;

public class ManagerLoginFilter<M> extends SubFilter<M, BasePage, String> {
    @Autowired
    private PageModelFilterContainer pageModelFilterContainer;

    public ManagerLoginFilter(String name, Class<? super M> modelClass) {
        super(name, modelClass, CONTEXT_ON_SITE_RTB.CAMPAIGN_ID, MANAGERS.PAGE_ID,
                new SubFilter<>(
                        "sub_login",
                        BasePage.class,
                        MANAGERS.MANAGER_ID,
                        USERS.ID,
                        UserFilters.LOGIN
                ) {
                    @Override
                    protected ModelFilterContainer<BaseUser> getModelFilterContainer() {
                        return new DefaultModelFilterContainer<>();
                    }
                }
        );
    }

    @Override
    protected ModelFilterContainer<BasePage> getModelFilterContainer() {
        return pageModelFilterContainer;
    }
}
