package ru.yandex.partner.core.entity.page.filter;

import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.PageWithManagers;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.BooleanFilter;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;
import ru.yandex.partner.core.filter.dbmeta.StringFilter;
import ru.yandex.partner.core.filter.meta.MatchMetaFilter;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.meta.MultistateMetaFilter;
import ru.yandex.partner.core.filter.meta.NumberMetaFilter;
import ru.yandex.partner.core.filter.meta.StringMetaFilter;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.dbschema.partner.tables.Pages;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

public class PageFilters {
    public static final MetaFilter<BasePage, Long> PAGE_ID
            = new NumberFilter<>("page_id", BasePage.class, PAGES.ID);

    public static final StringFilter<BasePage> CAPTION =
            new StringFilter<>("caption", BasePage.class, PAGES.CAPTION);

    public static final MetaFilter<BasePage, Long> OWNER_ID =
            new NumberFilter<>("owner_id", BasePage.class, PAGES.OWNER_ID);

    public static final MatchMetaFilter<BasePage, BaseUser> OWNER = new MatchMetaFilter<>("owner", BasePage.class);

    public static final MetaFilter<BasePage, Long> CREATOR_ID =
            new NumberFilter<>("creator_id", BasePage.class, PAGES.CREATOR_ID);

    public static final MatchMetaFilter<BasePage, Assistant> ASSISTANTS = new MatchMetaFilter<>(
            "assistants", BasePage.class);

    public static final MultistateMetaFilter<BasePage, PageStateFlag> MULTISTATE =
            new MultistateMetaFilter<>("multistate", BasePage.class);

    public static final BooleanFilter<BasePage> PARTNER_READ_ONLY = new BooleanFilter<>(
            "partner_readonly",
            BasePage.class,
            DSL.jsonValue(Pages.PAGES.OPTS.cast(SQLDataType.JSON), "$.partner_read_only").cast(SQLDataType.BIGINT)
    );

    public static final MetaFilter<PageWithManagers, Long> MANAGER_ID = new NumberMetaFilter<>("manager_id",
            PageWithManagers.class, Long.class);

    public static final StringMetaFilter<BasePage> ALL_DOMAIN = new StringMetaFilter<>("all_domain",
            FilterType.DOMAIN_MIRROR, BasePage.class);

    public static final MatchMetaFilter<BasePage, BaseDomain> DOMAIN = new MatchMetaFilter<>("domain", BasePage.class);
    public static final MatchMetaFilter<BasePage, BaseMirror> MIRROR = new MatchMetaFilter<>("mirror", BasePage.class);

    public static final MetaFilter<BasePage, Long> DOMAIN_ID = new NumberFilter<>("domain_id",
            BasePage.class, PAGES.DOMAIN_ID);

    private PageFilters() {
    }
}
