package ru.yandex.partner.core.entity.page.filter.all;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.assistant.filter.AssistantModelFilterContainer;
import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.AllPages;
import ru.yandex.partner.dbschema.partner.tables.Assistants;

@Component
public class AllPagesAssistantMatchDbFilter extends MatchDbFilter<AllPagesModel, Assistant, Assistant> {

    private AssistantModelFilterContainer assistantModelFilterContainer;

    @Autowired
    public AllPagesAssistantMatchDbFilter() {
        super(PageFilters.ASSISTANTS, AllPagesModel.class, Assistant.class,
                AllPages.ALL_PAGES.PAGE_ID, Assistants.ASSISTANTS.PAGE_ID);
    }

    @Autowired
    public void setAssistantModelFilterContainer(AssistantModelFilterContainer assistantModelFilterContainer) {
        this.assistantModelFilterContainer = assistantModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<Assistant> getModelFilterContainer() {
        return assistantModelFilterContainer;
    }
}
