package ru.yandex.partner.core.entity.page.filter.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.assistant.filter.AssistantModelFilterContainer;
import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BaseExternalPage;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.Assistants;

import static ru.yandex.partner.dbschema.partner.tables.Pages.PAGES;

@Component
public class PageAssistantMatchDbFilter extends MatchDbFilter<BaseExternalPage, Assistant, Assistant> {

    private AssistantModelFilterContainer assistantModelFilterContainer;

    @Autowired
    public PageAssistantMatchDbFilter() {
        super(PageFilters.ASSISTANTS, BaseExternalPage.class, Assistant.class,
                PAGES.ID, Assistants.ASSISTANTS.PAGE_ID);
    }

    @Autowired
    public void setAssistantModelFilterContainer(AssistantModelFilterContainer assistantModelFilterContainer) {
        this.assistantModelFilterContainer = assistantModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<Assistant> getModelFilterContainer() {
        return assistantModelFilterContainer;
    }
}
