package ru.yandex.partner.core.entity.page.filter.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.domain.filter.DomainModelFilterContainer;
import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BaseExternalPage;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.Site;

import static ru.yandex.partner.dbschema.partner.tables.Pages.PAGES;

@Component
public class PageDomainMatchDbFilter extends MatchDbFilter<BaseExternalPage, BaseDomain, BaseDomain> {

    private DomainModelFilterContainer domainModelFilterContainer;

    @Autowired
    public PageDomainMatchDbFilter() {
        super(PageFilters.DOMAIN, BaseExternalPage.class, BaseDomain.class,
                PAGES.DOMAIN_ID,
                Site.SITE.ID);
    }

    @Autowired
    public void setDomainModelFilterContainer(DomainModelFilterContainer domainModelFilterContainer) {
        this.domainModelFilterContainer = domainModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<BaseDomain> getModelFilterContainer() {
        return domainModelFilterContainer;
    }
}
