package ru.yandex.partner.core.entity.page.filter.external;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BaseExternalPage;
import ru.yandex.partner.core.filter.db.DomainMirrorDbFilter;

@Configuration
public class PageFilterConfiguration {

    @Bean
    public DomainMirrorDbFilter<BaseExternalPage> pageDomainMirrorDbFilter(
            PageDomainMatchDbFilter pageDomainMatchDbFilter, PageMirrorMatchDbFilter pageMirrorMatchDbFilter) {
        return new DomainMirrorDbFilter<>(
                PageFilters.ALL_DOMAIN,
                BaseExternalPage.class,
                pageDomainMatchDbFilter,
                pageMirrorMatchDbFilter
        );
    }
}
