package ru.yandex.partner.core.entity.page.filter.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.mirror.filter.MirrorModelFilterContainer;
import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BaseExternalPage;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteMirrors;

import static ru.yandex.partner.dbschema.partner.tables.Pages.PAGES;

@Component
public class PageMirrorMatchDbFilter extends MatchDbFilter<BaseExternalPage, BaseMirror, BaseMirror> {

    private MirrorModelFilterContainer mirrorModelFilterContainer;


    @Autowired
    public PageMirrorMatchDbFilter() {
        super(PageFilters.MIRROR, BaseExternalPage.class, BaseMirror.class,
                PAGES.PAGE_ID,
                ContextOnSiteMirrors.CONTEXT_ON_SITE_MIRRORS.CAMPAIGN_ID);
    }

    @Autowired
    public void setMirrorModelFilterContainer(MirrorModelFilterContainer mirrorModelFilterContainer) {
        this.mirrorModelFilterContainer = mirrorModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<BaseMirror> getModelFilterContainer() {
        return mirrorModelFilterContainer;
    }
}
