package ru.yandex.partner.core.entity.page.filter.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.multistate.ContextPageMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.page.PageStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class PageMultistateDbFilter extends MultistateDbFilter<ContextPage, PageStateFlag> {

    @Autowired
    public PageMultistateDbFilter(ContextPageMultistateGraph multistateGraph) {
        super(PageFilters.MULTISTATE, ContextPage.class, multistateGraph,
                PAGES.MULTISTATE);
    }
}
