package ru.yandex.partner.core.entity.page.filter.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.assistant.filter.AssistantModelFilterContainer;
import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.Assistants;

import static ru.yandex.partner.dbschema.partner.tables.Pages.PAGES;

@Component
public class InternalPageAssistantMatchDbFilter extends MatchDbFilter<InternalContextPage, Assistant, Assistant> {

    private AssistantModelFilterContainer assistantModelFilterContainer;

    @Autowired
    public InternalPageAssistantMatchDbFilter() {
        super(PageFilters.ASSISTANTS, InternalContextPage.class, Assistant.class,
                PAGES.ID, Assistants.ASSISTANTS.PAGE_ID);
    }

    @Autowired
    public void setAssistantModelFilterContainer(AssistantModelFilterContainer assistantModelFilterContainer) {
        this.assistantModelFilterContainer = assistantModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<Assistant> getModelFilterContainer() {
        return assistantModelFilterContainer;
    }
}
