package ru.yandex.partner.core.entity.page.filter.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.domain.filter.InternalDomainModelFilterContainer;
import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.InternalSite;

import static ru.yandex.partner.dbschema.partner.tables.Pages.PAGES;

@Component
public class InternalPageDomainMatchDbFilter extends MatchDbFilter<InternalContextPage, BaseDomain, BaseDomain> {

    private InternalDomainModelFilterContainer internalDomainModelFilterContainer;

    @Autowired
    public InternalPageDomainMatchDbFilter() {
        super(PageFilters.DOMAIN, InternalContextPage.class, BaseDomain.class,
                PAGES.DOMAIN_ID,
                InternalSite.INTERNAL_SITE.ID);
    }

    @Autowired
    public void setInternalDomainModelFilterContainer(
            InternalDomainModelFilterContainer internalDomainModelFilterContainer) {

        this.internalDomainModelFilterContainer = internalDomainModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<BaseDomain> getModelFilterContainer() {
        return internalDomainModelFilterContainer;
    }
}
