
package ru.yandex.partner.core.entity.page.filter.internal;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.filter.db.DomainMirrorDbFilter;


@Configuration
public class InternalPageFilterConfiguration {

    @Bean
    public DomainMirrorDbFilter<InternalContextPage> internalContextPageDomainMirrorDbFilter(
            InternalPageDomainMatchDbFilter internalPageDomainMatchDbFilter,
            InternalPageMirrorMatchDbFilter internalPageMirrorMatchDbFilter) {

        return new DomainMirrorDbFilter<>(
                PageFilters.ALL_DOMAIN,
                InternalContextPage.class,
                internalPageDomainMatchDbFilter,
                internalPageMirrorMatchDbFilter
        );
    }

}
