package ru.yandex.partner.core.entity.page.filter.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalPageWithManagers;
import ru.yandex.partner.core.filter.container.DefaultModelFilterContainer;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.SubDbFilter;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;
import ru.yandex.partner.dbschema.partner.tables.Managers;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class InternalPageManagersDbFilter extends SubDbFilter<InternalPageWithManagers, ModelWithId, Long> {

    @Autowired
    public InternalPageManagersDbFilter() {
        super(PageFilters.MANAGER_ID,
                new NumberFilter<>("manager_id", ModelWithId.class, Managers.MANAGERS.MANAGER_ID),
                InternalPageWithManagers.class,
                PAGES.ID,
                Managers.MANAGERS.PAGE_ID);
    }

    @Override
    protected ModelFilterContainer<ModelWithId> getModelFilterContainer() {
        return new DefaultModelFilterContainer<>();
    }
}
