package ru.yandex.partner.core.entity.page.filter.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.mirror.filter.InternalMirrorModelFilterContainer;
import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.InternalContextOnSiteMirrors;

import static ru.yandex.partner.dbschema.partner.tables.Pages.PAGES;

@Component
public class InternalPageMirrorMatchDbFilter extends MatchDbFilter<InternalContextPage, BaseMirror, BaseMirror> {

    private InternalMirrorModelFilterContainer internalMirrorModelFilterContainer;

    @Autowired
    public InternalPageMirrorMatchDbFilter() {
        super(PageFilters.MIRROR, InternalContextPage.class, BaseMirror.class,
                PAGES.ID, InternalContextOnSiteMirrors.INTERNAL_CONTEXT_ON_SITE_MIRRORS.CAMPAIGN_ID);
    }

    @Autowired
    public void setInternalMirrorModelFilterContainer(
            InternalMirrorModelFilterContainer internalMirrorModelFilterContainer) {

        this.internalMirrorModelFilterContainer = internalMirrorModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<BaseMirror> getModelFilterContainer() {
        return internalMirrorModelFilterContainer;
    }
}
