package ru.yandex.partner.core.entity.page.filter.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.multistate.InternalContextPageMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.page.PageStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;


@Component
public class InternalPageMultistateDbFilter extends MultistateDbFilter<InternalContextPage, PageStateFlag> {

    @Autowired
    public InternalPageMultistateDbFilter(InternalContextPageMultistateGraph multistateGraph) {
        super(PageFilters.MULTISTATE, InternalContextPage.class, multistateGraph,
                PAGES.MULTISTATE);
    }
}
