package ru.yandex.partner.core.entity.page.filter.internal;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.filter.db.DbFilter;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;

@Component
public class InternalPageOwnerIdFilter implements DbFilter<InternalContextPage, Long> {

    @Override
    public MetaFilter<? super InternalContextPage, Long> getMetaFilter() {
        return PageFilters.OWNER_ID;
    }

    @Override
    public Class<InternalContextPage> getResolvableModelClass() {
        return InternalContextPage.class;
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<Long> values) {
        boolean adinside = switch (operator) {
            case GREATER -> values.stream().anyMatch(value -> value > CoreConstants.ADINSIDE_USER_ID);
            case GREATER_OR_EQUALS -> values.stream().anyMatch(value -> value >= CoreConstants.ADINSIDE_USER_ID);
            case LOWER -> values.stream().anyMatch(value -> value < CoreConstants.ADINSIDE_USER_ID);
            case LOWER_OR_EQUALS -> values.stream().anyMatch(value -> value <= CoreConstants.ADINSIDE_USER_ID);
            case IN, EQUALS -> values.contains(CoreConstants.ADINSIDE_USER_ID);
            case NOT_IN, NOT_EQUALS -> !values.contains(CoreConstants.ADINSIDE_USER_ID);
            default -> throw new IllegalArgumentException("Unsupported operator. FilterOperator = "
                    .concat(operator.name()));
        };

        if (adinside) {
            return DSL.trueCondition();
        } else {
            return DSL.falseCondition();
        }
    }
}
