package ru.yandex.partner.core.entity.page.filter.internal;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.Select;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.filter.UserModelFilterContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.db.DbFilter;
import ru.yandex.partner.core.filter.exceptions.FilterOperatorException;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;
import ru.yandex.partner.dbschema.partner.tables.Users;
import ru.yandex.partner.dbschema.partner.tables.records.UsersRecord;

@Component
public class InternalPageOwnerMatchDbFilter implements DbFilter<InternalContextPage, CoreFilterNode<BaseUser>> {
    @Autowired
    private UserModelFilterContainer userModelFilterContainer;

    @Override
    public MetaFilter<? super InternalContextPage, CoreFilterNode<BaseUser>> getMetaFilter() {
        return PageFilters.OWNER;
    }

    @Override
    public Class<InternalContextPage> getResolvableModelClass() {
        return InternalContextPage.class;
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<CoreFilterNode<BaseUser>> values) {
        var coreFilterNode = FilterUtils.getSingleValueOrThrow(values, operator);

        Select<UsersRecord> selectQuery = DSL.selectFrom(Users.USERS).where(
                coreFilterNode.and(CoreFilterNode.eq(UserFilters.ID, CoreConstants.ADINSIDE_USER_ID))
                        .toCondition(BaseUser.class, userModelFilterContainer));

        return switch (operator) {
            case MATCH -> DSL.exists(selectQuery);
            case NOT_MATCH -> DSL.notExists(selectQuery);
            default -> throw new FilterOperatorException();
        };
    }
}
