package ru.yandex.partner.core.entity.page.filter.mobile;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.domain.filter.DomainFilters;
import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.StringDbFilter;

import static ru.yandex.partner.dbschema.partner.Tables.MOBILE_APP;

@Component
public class MobileAppFilterContainer extends CommonModelFilterContainer<BaseDomain> {
    MobileAppFilterContainer() {
        super(List.of(new StringDbFilter<>(DomainFilters.DOMAIN, BaseDomain.class, MOBILE_APP.STORE_ID)));
    }

    @Override
    public Class<BaseDomain> getModelClass() {
        return BaseDomain.class;
    }
}
