package ru.yandex.partner.core.entity.page.filter.mobile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.Tables;

@Component
public class MobileAppSettingsAppMatchDbFilter extends MatchDbFilter<MobileAppSettings, BaseDomain, BaseDomain> {
    private MobileAppFilterContainer mobileAppFilterContainer;

    public MobileAppSettingsAppMatchDbFilter() {
        super(PageFilters.DOMAIN, MobileAppSettings.class, BaseDomain.class,
                Tables.PAGES.DOMAIN_ID, Tables.MOBILE_APP.ID);
    }

    @Autowired
    public void setMobileAppFilterContainer(MobileAppFilterContainer mobileAppFilterContainer) {
        this.mobileAppFilterContainer = mobileAppFilterContainer;
    }

    @Override
    protected ModelFilterContainer<BaseDomain> getModelFilterContainer() {
        return mobileAppFilterContainer;
    }
}
