package ru.yandex.partner.core.entity.page.filter.mobile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.assistant.filter.AssistantModelFilterContainer;
import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BaseMobileAppSettings;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.Assistants;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class MobileAppSettingsAssistantMatchDbFilter
        extends MatchDbFilter<BaseMobileAppSettings, Assistant, Assistant> {

    private AssistantModelFilterContainer assistantModelFilterContainer;

    @Autowired
    public MobileAppSettingsAssistantMatchDbFilter() {
        super(PageFilters.ASSISTANTS, BaseMobileAppSettings.class, Assistant.class,
                PAGES.ID, Assistants.ASSISTANTS.PAGE_ID);
    }

    @Autowired
    public void setAssistantModelFilterContainer(AssistantModelFilterContainer assistantModelFilterContainer) {
        this.assistantModelFilterContainer = assistantModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<Assistant> getModelFilterContainer() {
        return assistantModelFilterContainer;
    }
}
