package ru.yandex.partner.core.entity.page.filter.mobile;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BaseMobileAppSettings;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.db.NoDbFilter;

@Configuration
public class MobileAppSettingsFilterConfiguration {

    @Bean
    public NoDbFilter<BaseMobileAppSettings, CoreFilterNode<BaseMirror>> mobileAppSettingsMatchMirror() {
        return new NoDbFilter<>(PageFilters.MIRROR, BaseMobileAppSettings.class);
    }


    @Bean
    public NoDbFilter<BaseMobileAppSettings, String> mobileAppSettingsAllDomainMirror() {
        return new NoDbFilter<>(PageFilters.ALL_DOMAIN, BaseMobileAppSettings.class);
    }
}
