package ru.yandex.partner.core.entity.page.filter.mobile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.page.multistate.MobileAppMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.page.PageStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;


@Component
public class MobileAppSettingsMultistateDbFilter extends MultistateDbFilter<MobileAppSettings,
        PageStateFlag> {

    @Autowired
    public MobileAppSettingsMultistateDbFilter(MobileAppMultistateGraph multistateGraph) {
        super(PageFilters.MULTISTATE, MobileAppSettings.class, multistateGraph,
                PAGES.MULTISTATE);
    }
}
