
package ru.yandex.partner.core.entity.page.filter.mobile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.user.filter.UserModelFilterContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.Users;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class MobileAppSettingsOwnerMatchDbFilter extends MatchDbFilter<MobileAppSettings, BaseUser, BaseUser> {

    private UserModelFilterContainer userModelFilterContainer;

    public MobileAppSettingsOwnerMatchDbFilter() {
        super(PageFilters.OWNER, MobileAppSettings.class, BaseUser.class,
                PAGES.OWNER_ID, Users.USERS.ID);
    }

    @Autowired
    public void setUserModelFilterContainer(UserModelFilterContainer userModelFilterContainer) {
        this.userModelFilterContainer = userModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<BaseUser> getModelFilterContainer() {
        return userModelFilterContainer;
    }
}
