package ru.yandex.partner.core.entity.page.filter.mobile.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.domain.model.BaseDomain;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.filter.mobile.MobileAppFilterContainer;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.Tables;

@Component
public class InternalMobileAppAppMatchDbFilter extends MatchDbFilter<InternalMobileApp, BaseDomain, BaseDomain> {
    private MobileAppFilterContainer mobileAppFilterContainer;

    public InternalMobileAppAppMatchDbFilter() {
        super(PageFilters.DOMAIN, InternalMobileApp.class, BaseDomain.class,
                Tables.PAGES.DOMAIN_ID, Tables.INTERNAL_MOBILE_APP.ID);
    }

    @Autowired
    public void setMobileAppFilterContainer(MobileAppFilterContainer mobileAppFilterContainer) {
        this.mobileAppFilterContainer = mobileAppFilterContainer;
    }

    @Override
    protected ModelFilterContainer<BaseDomain> getModelFilterContainer() {
        return mobileAppFilterContainer;
    }
}
