package ru.yandex.partner.core.entity.page.filter.mobile.internal;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.mirror.model.BaseMirror;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BaseInternalMobileApp;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.db.NoDbFilter;

@Configuration
public class InternalMobileAppFilterConfiguration {

    @Bean
    public NoDbFilter<BaseInternalMobileApp, CoreFilterNode<BaseMirror>> internalMobileAppMatchMirror() {
        return new NoDbFilter<>(PageFilters.MIRROR, BaseInternalMobileApp.class);
    }


    @Bean
    public NoDbFilter<BaseInternalMobileApp, String> internalMobileAppAllDomainMirror() {
        return new NoDbFilter<>(PageFilters.ALL_DOMAIN, BaseInternalMobileApp.class);
    }

    @Bean
    public NoDbFilter<BaseInternalMobileApp, CoreFilterNode<Assistant>> internalMobileAppAssistants() {
        return new NoDbFilter<>(PageFilters.ASSISTANTS, BaseInternalMobileApp.class);
    }
}
