package ru.yandex.partner.core.entity.page.filter.mobile.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.multistate.InternalMobileAppMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.page.PageStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;


@Component
public class InternalMobileAppMultistateDbFilter extends MultistateDbFilter<InternalMobileApp,
        PageStateFlag> {

    @Autowired
    public InternalMobileAppMultistateDbFilter(InternalMobileAppMultistateGraph multistateGraph) {
        super(PageFilters.MULTISTATE, InternalMobileApp.class, multistateGraph,
                PAGES.MULTISTATE);
    }
}
