package ru.yandex.partner.core.entity.page.repository;

import java.util.List;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.direct.multitype.repository.RepositoryTypeSupportFacade;
import ru.yandex.direct.multitype.repository.TypedRepository;
import ru.yandex.partner.core.configuration.DslContextProviderStub;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.multitype.repository.PartnerModifyRepository;
import ru.yandex.partner.core.multitype.repository.relation.Id;
import ru.yandex.partner.core.page.PageType;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class PageModifyRepository
        extends PartnerModifyRepository<BasePage, BasePage, PageOperationContainer,
        PageOperationContainer> {

    public PageModifyRepository(
            DSLContext dslContext,
            RepositoryTypeSupportFacade<BasePage, PageType, PageOperationContainer, PageOperationContainer>
                    typeSupportFacade,
            TypedRepository<BasePage, ?, PageOperationContainer, PageOperationContainer> typedRepository
    ) {
        super(
                new DslContextProviderStub(dslContext),
                typeSupportFacade,
                typedRepository,
                Id.column(PAGES.ID)
        );
    }

    @Override
    protected void generateIds(PageOperationContainer addContainer, List<? extends BasePage> models) {

    }

    @Override
    protected Table<?> getLockTable() {
        return PAGES;
    }
}
