package ru.yandex.partner.core.entity.page.repository;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SelectQuery;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.repository.filter.ConditionFilter;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.filter.PageModelFilterContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.repository.type.PageRepositoryTypeSupportFacade;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.multitype.repository.PartnerTypedRepository;
import ru.yandex.partner.core.page.PageType;

import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Repository
@ParametersAreNonnullByDefault
public class PageTypedRepository
        extends PartnerTypedRepository<BasePage, PageType, PageOperationContainer, PageOperationContainer> {

    @Autowired
    public PageTypedRepository(PageRepositoryTypeSupportFacade typeSupportFacade,
                               DSLContext dslContext,
                               PageModelFilterContainer metaFilterService) {
        super(dslContext, typeSupportFacade, metaFilterService);
    }

    @Override
    protected ConditionFilter getIdFilter(Collection<Long> pageIds) {
        return whereInFilter(PAGES.ID, pageIds);
    }

    @Override
    protected Table<?> getBaseTable() {
        return PAGES;
    }

    public <S extends BasePage> Long getPageCountByCondition(
            CoreFilterNode<? super S> coreFilterNode, Class<S> clazz) {
        SelectQuery<Record1<Integer>> query = getSelectCountQuery(this.dslContext, clazz);
        applyFilterToQuery(clazz, coreFilterNode, query);
        return query.fetchSingleInto(Long.class);
    }

    @Override
    protected <S extends BasePage> CoreFilterNode<S> getCoreFilterNodeById(Collection<Long> ids) {
        return CoreFilterNode.in(PageFilters.PAGE_ID, ids);
    }

    @Override
    protected ModelProperty<? extends Model, Long> getIdModelProperty() {
        return BasePage.ID;
    }
}
