package ru.yandex.partner.core.entity.page.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;

import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.partner.core.entity.page.model.BasePage;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@ParametersAreNonnullByDefault
public abstract class AbstractPageRepositoryTypeSupportWithMapper<P extends BasePage, R extends Record, PC>
        extends AbstractPageRepositoryTypeSupport<P, PC> implements PageRepositoryTypeSupportWithMapper<P, PC> {

    public AbstractPageRepositoryTypeSupportWithMapper(DSLContext dslContext) {
        super(dslContext);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<P>> appliedChanges) {
        updateHelperAggregator.getOrCreate(PAGES.ID)
                .processUpdateAll(getJooqMapper(), appliedChanges);
    }
}
