package ru.yandex.partner.core.entity.page.repository.type.contextfileds;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.page.model.PageWithBlocksLimit;

import static ru.yandex.direct.validation.constraint.NumberConstraints.notGreaterThan;
import static ru.yandex.partner.core.entity.page.service.validation.defects.PageDefectIds.ContextFieldDefectIds.LIMIT_EXCEEDED;

@Component
public class PageWithBlockLimitValidatorProvider {


    public <M extends PageWithBlocksLimit> Validator<M, Defect> validator() {
        return page -> {
            var validationBuilder = ModelItemValidationBuilder.of(page);
            validationBuilder.item(PageWithBlocksLimit.BLOCKS_LIMIT).check(notGreaterThan(page.getBlocksLimit()),
                    new Defect(LIMIT_EXCEEDED));
            return validationBuilder.getResult();
        };
    }
}
