package ru.yandex.partner.core.entity.page.repository.type.contextfileds;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.PageWithBlocksLimit;
import ru.yandex.partner.core.multitype.service.validation.type.AbstractValidationTypeSupport;

@Component
public class PageWithContextFieldsValidationTypeSupport
        extends AbstractValidationTypeSupport<PageWithBlocksLimit, PageOperationContainer> {

    private final Validator<PageWithBlocksLimit, Defect> validatorProvider;

    @Autowired
    public PageWithContextFieldsValidationTypeSupport(PageWithBlockLimitValidatorProvider validatorProvider) {

        this.validatorProvider = validatorProvider.validator();
    }

    @Override
    public Class<PageWithBlocksLimit> getTypeClass() {
        return PageWithBlocksLimit.class;
    }

    @Override
    public ValidationResult<List<PageWithBlocksLimit>, Defect> validate(
            PageOperationContainer container,
            ValidationResult<List<PageWithBlocksLimit>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider)
                .getResult();
    }
}
