package ru.yandex.partner.core.entity.page.service;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.filter.CoreFilterNode;

@Component
public class InternalMobileRtbReachablePageService extends BaseReachablePageService<InternalMobileRtbBlock> {

    @Autowired
    public InternalMobileRtbReachablePageService(ModelQueryService<BasePage> pageService,
                                                 ActionContextFacade contextPageActionContext) {
        super(pageService, InternalMobileApp.allModelProperties(), contextPageActionContext);
    }

    @NotNull
    @Override
    protected <T extends BasePage> CoreFilterNode<T> customPageFilter() {
        return CoreFilterNode.neutral();
    }

    @Override
    public Class<InternalMobileRtbBlock> getBlockClass() {
        return InternalMobileRtbBlock.class;
    }
}
