package ru.yandex.partner.core.entity.page.service;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.filter.CoreFilterNode;

@Component
public class InternalRtbReachablePageService extends BaseReachablePageService<InternalRtbBlock> {

    @Autowired
    public InternalRtbReachablePageService(ModelQueryService<BasePage> pageService,
                                           ActionContextFacade contextPageActionContext) {
        // TODO: 30.03.2022 указывать конкретное множество пропертей вместо всех существующих
        super(pageService, InternalContextPage.allModelProperties(), contextPageActionContext);
    }

    @NotNull
    @Override
    protected <T extends BasePage> CoreFilterNode<T> customPageFilter() {
        return CoreFilterNode.neutral();
    }

    @Override
    public Class<InternalRtbBlock> getBlockClass() {
        return InternalRtbBlock.class;
    }
}
