package ru.yandex.partner.core.entity.page.service;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.filter.CoreFilterNode;

@Service
public class MobileAppSettingsReachablePageService extends BaseReachablePageService<MobileRtbBlock> {

    @Autowired
    public MobileAppSettingsReachablePageService(ModelQueryService<BasePage> pageService,
                                                 ActionContextFacade actionContextFacade) {
        super(pageService, MobileAppSettings.allModelProperties(), actionContextFacade);
    }

    @NotNull
    @Override
    protected <T extends BasePage> CoreFilterNode<T> customPageFilter() {
        return CoreFilterNode.neutral();
    }

    @Override
    public Class<MobileRtbBlock> getBlockClass() {
        return MobileRtbBlock.class;
    }
}
