package ru.yandex.partner.core.entity.page.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.Query;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.repository.PageTypedRepository;
import ru.yandex.partner.core.entity.tasks.doaction.DoActionFilterEnum;
import ru.yandex.partner.core.filter.meta.MetaFilter;

import static ru.yandex.direct.multitype.typesupport.TypeFilteringUtils.filterModelsOfClass;

@Service
public class PageService implements ModelQueryService<BasePage> {

    private final PageTypedRepository pageTypedRepository;

    @Autowired
    public PageService(PageTypedRepository pageTypedRepository) {
        this.pageTypedRepository = pageTypedRepository;
    }

    @Override
    public <S extends BasePage> List<S> findAll(Query<S> opts) {
        return filterModelsOfClass(
                pageTypedRepository.getAll(opts),
                opts.getClazz()
        );
    }

    @Override
    public <S extends BasePage> long count(Query<S> opts) {
        return pageTypedRepository.getPageCountByCondition(opts.getFilter(), opts.getClazz());
    }

    @Override
    public ModelProperty<? extends Model, Long> getIdModelProperty() {
        return BasePage.ID;
    }

    @Override
    public Class<BasePage> getBaseClass() {
        return BasePage.class;
    }

    @Override
    public <S extends BasePage>
    MetaFilter<? super S, ?> getMetaFilterForDoAction(DoActionFilterEnum doActionFilterEnum) {
        return switch (doActionFilterEnum) {
            case PAGE_ID -> PageFilters.PAGE_ID;
            case MULTISTATE -> PageFilters.MULTISTATE;
        };
    }
}
