package ru.yandex.partner.core.entity.page.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.page.model.BasePage;

@ParametersAreNonnullByDefault
public class PageUpdateOperationConstants {

    /**
     * Если саппорт навешен на класс, который есть в этом белом списке или на класс, который наследуются от класса,
     * который есть в этом белом списке - то такой саппорт будет вызываться всегда, независимо от изменившихся данных.
     */
    public static final Set<Class<? extends BasePage>> PAGE_TYPE_SUPPORT_CLASS_WHITE_LIST = Set.of(
            BasePage.class
    );

    private PageUpdateOperationConstants() {

    }
}
