package ru.yandex.partner.core.entity.page.service;

import java.util.List;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.entity.LimitOffset;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.utils.OrderBy;

public interface ReachablePageService<B extends BaseBlock> {
    <T extends BasePage> List<T> getReachablePages(
            @NotNull CoreFilterNode<? super T> baseFilter,
            Class<T> clazz
    );

    <T extends BasePage> List<T> getReachablePagesForAdd(
            @NotNull CoreFilterNode<? super T> baseFilter,
            LimitOffset limitOffset,
            Set<ModelProperty<? extends Model, ?>> modelProperties,
            List<OrderBy> orderByList,
            Class<T> clazz
    );

    <T extends BasePage> List<T> getReachablePagesForAdd(
            @NotNull CoreFilterNode<? super T> baseFilter,
            Class<T> clazz
    );

    <T extends BasePage> List<T> getReachablePages(
            @NotNull CoreFilterNode<? super T> baseFilter,
            LimitOffset limitOffset,
            Set<ModelProperty<? extends Model, ?>> modelProperties,
            List<OrderBy> orderByList,
            Class<T> clazz
    );

    Class<B> getBlockClass();

    <T extends BasePage> MetaFilter<? super T, Long> getPageIdMetaFilter();
}
