package ru.yandex.partner.core.entity.page.service;

import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.service.entitymanager.EntityManager;

@Component
public class RtbReachablePageService extends BaseReachablePageService<RtbBlock> {
    /**
     * <p>
     * Пользователи, не согласившиеся переходить на РТБ.
     * По-умолчанию - один логин мейлру.
     * </p>
     * <p>
     * Аналог <a href="https://nda.ya.ru/t/RDnFX3c442GFPu">$M_RU_TEXT_USER_ID в perl</a>.
     * См. <a href="https://st.yandex-team.ru/PI-8722">PI-8722</a>
     * </p>
     */
    private final Set<Long> rtbInaccessiblePageOwners;

    public RtbReachablePageService(
            @Value("${rtbInaccessiblePageOwners:28166288}") Set<Long> rtbInaccessiblePageOwners,
            ModelQueryService<BasePage> pageService, ActionContextFacade contextPageActionContext,
            EntityManager entityManager) {
        super(pageService, ContextPage.allModelProperties(), contextPageActionContext);
        this.rtbInaccessiblePageOwners = rtbInaccessiblePageOwners;
    }

    @NotNull
    @Override
    public <T extends BasePage> CoreFilterNode<T> customPageFilter() {
        return PageFilters.OWNER_ID.notIn(rtbInaccessiblePageOwners);
    }

    @Override
    public Class<RtbBlock> getBlockClass() {
        return RtbBlock.class;
    }
}
