package ru.yandex.partner.core.entity.page.service.validation.defects.presentation;

import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.partner.core.entity.page.service.validation.defects.PageDefectIds;
import ru.yandex.partner.libs.i18n.TranslatableError;

import static ru.yandex.partner.core.validation.defects.presentation.DefectPresentationProviders.defaultDefectProvider;

public class PageDefectPresentationRegistry {
    private PageDefectPresentationRegistry() {
    }

    @SuppressWarnings("checkstyle:methodlength")
    public static DefaultDefectPresentationRegistry<TranslatableError> pageDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(PageDefectIds.ContextFieldDefectIds.LIMIT_EXCEEDED,
                        defaultDefectProvider(PageValidationMsg.LIMIT_EXCEEDED))
                .build();
    }
}
