package ru.yandex.partner.core.entity.page.service.validation.defects.presentation;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum PageValidationMsg implements GettextMsg {
    LIMIT_EXCEEDED(msg("You cannot add another block. Limit exceeded"),
            "lib__Application__Model__Role__Has__CountPageBlocks.pm"),
    PAGE_NOT_FOUND(msg("Page with page_id %s not found"), "lib__Application__Model__Role__Has__DSPS.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    PageValidationMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    PageValidationMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
