package ru.yandex.partner.core.entity.page.service.validation.type;

import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.PathNode;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.repository.type.PageRepositoryTypeSupport;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupport;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;

@Component
public class PageValidationTypeSupportFacade
        extends ValidationTypeSupportFacade<BasePage, PageOperationContainer, PageOperationContainer> {

    public PageValidationTypeSupportFacade(
            List<? extends ValidationTypeSupport<? extends BasePage, PageOperationContainer>>
                    validationTypeSupports,
            List<PageRepositoryTypeSupport<? extends BasePage, PageOperationContainer>> typeSupports) {
        super(validationTypeSupports, typeSupports, new TypeSupportAffectionHelper<>(Set.of()),
                PageOperationContainer::create);
    }

    @Override
    public void addPreValidate(PageOperationContainer container,
                               ValidationResult<? extends List<? extends BasePage>, Defect> vr) {
        // TODO до появления конкретных валидаторов, т.к. action требует наличия объектов в соотв. путях.
        for (int i = 0; i < vr.getValue().size(); i++) {
            vr.addSubResult(new PathNode.Index(i), new ValidationResult<>(vr.getValue().get(i)));
        }
        super.addPreValidate(container, vr);
    }
}
