package ru.yandex.partner.core.entity.page.type.allowedamp;

import java.util.Set;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.page.container.PageOperationContainer;
import ru.yandex.partner.core.entity.page.model.PageWithAllowedAmp;
import ru.yandex.partner.core.entity.page.repository.type.AbstractPageRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.utils.CommonConverters;
import ru.yandex.partner.dbschema.partner.tables.records.PagesRecord;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class PageWithAllowedAmpRepositoryTypeSupport extends
        AbstractPageRepositoryTypeSupportWithMapper<PageWithAllowedAmp, PagesRecord, PageOperationContainer> {
    private final JooqMapper<PageWithAllowedAmp> mapper;

    public PageWithAllowedAmpRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        mapper = JooqMapperBuilder.<PageWithAllowedAmp>builder()
                .map(convertibleProperty(
                        PageWithAllowedAmp.ALLOWED_AMP, PAGES.ALLOWED_AMP,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong)
                ).build();
    }

    @Override
    public JooqMapper<PageWithAllowedAmp> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<PageWithAllowedAmp> getTypeClass() {
        return PageWithAllowedAmp.class;
    }

    @Override
    public Set<ModelProperty<? super PageWithAllowedAmp, ?>> getAffectedModelProperties() {
        return Set.of(PageWithAllowedAmp.ALLOWED_AMP);
    }
}
